﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class AdminEditUsersVisn : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");

    USER userEntry;
    UsersManager usersManager = new UsersManager();

    public override string MenuItemName()
    {
        return "Edit User VISN Access";
    }

    public override string AppObjectCode()
    {
        return "TBI ADMIN USER VISN";
    }

    public override string TopMenuName()
    {
        return "Administration";
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = _currentRegistry;

        if (!IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;

            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

            //if userID is not supplied or zero then display a list of all user roles
            if (userID == null || userID == 0)
            {
                userID = 0;

                //set page display for list of all user roles
                SetFormDisplay(false);

            }
            else
            {
                //set page to display for single user role management
                SetFormDisplay(true);

            }

        }

        if (HiddenFieldUserID.Value != "0")
        {
            //Create User Entity object and Set properties to state of form
            getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
        }


        if (IsPostBack && userEntry != null)
        {
            LoadObjectFromControls();
        }
    }

    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);

        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null)
        {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;
        }
    }


    void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }
            LoadControlsFromObject();
        }
    }

    #region Object/Form Mapping

    private void LoadControlsFromObject()
    {
        //Registry
        HiddenFieldRegistryName.Value = _currentRegistry;

        //TO DO : modify drop down population to add archived item if persisted in entity 
        //          and remove "-- Select a Value --" when an item is selected and field is not nullable 

        //Username:
        LabelUsername.Text = userEntry.USERNAME;

        //Full Name:
        LabelFullName.Text = userEntry.FULL_NAME;

        //Employee Number:
        LabelEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

        //Job Title:
        LabelJobTitle.Text = userEntry.JOB_TITLE;

        //userid 
        HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
    }

    private void LoadObjectFromControls()
    {

        //User Roles
        //foreach (ListItem checkboxListRole in CheckBoxListUserRoles.Items)
        //{
 
        //}

    }

    #endregion

    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        int returnSaveValue;

        returnSaveValue = usersManager.Update(userEntry);

        //Set Broken Rule Error Display
        if (userEntry.BrokenRules.Count == 0)
        {
            ErrorList1.Visible = false;

        }
        else
        {
            ErrorList1.Visible = true;
        }

        ErrorList1.BrokenRules = userEntry.BrokenRules;

        //TO DO
        //Display Save Message
        //Refresh entity root data
    }

    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        SetFormDisplay(true);
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {

        userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text);

        if (userEntry != null)
        {
            GridViewUserVISNs.DataSourceID = "ObjectDataSourceUsersVISNs";
            GridViewUserVISNs.DataBind();
        }

    }


    protected void SetFormDisplay(bool isSingleUserRoleManagement)
    {
        LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        if (isSingleUserRoleManagement)
        {
            //set page to display for single user role management
            PanelListUserVisns.Visible = false;
            PanelUserInformation.Visible = true;

            //Modify breadcrumb to display editing user id
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Edit VISNs for User ID : " + HiddenFieldUserID.Value;

        }
        else
        {
            //set page display for list of all user roles
            PanelListUserVisns.Visible = true;
            PanelUserInformation.Visible = false;

            //Modify breadcrumb to display adding new
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > List all User VISNs ";

        }
    }

    #endregion
}
